using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Object_Returner : MonoBehaviour
{

    Quaternion Original_Rotation;
    Vector3 Original_Position;

    [SerializeField, Tooltip("Wait time before return to original position")]
    public float ReturnTime = 3;
    [SerializeField, Tooltip("Tolerable offset")]
    public float ObjectOffset = 0.2f;
    Rigidbody Rb;

    // Start is called before the first frame update
    void Awake()
    {

        Rb = transform.GetComponent<Rigidbody>();
        Original_Position = Rb.position;
        Original_Rotation = Rb.rotation;

    }

    // Update is called once per frame
    float elapsed_time = 0;
    
    void FixedUpdate()
    {
        if (Rb == null) return;
        if (!Rb.isKinematic && (Original_Position - Rb.position).magnitude > ObjectOffset) elapsed_time += Time.deltaTime;
        if(elapsed_time > ReturnTime)
        {
            Rb.position = Original_Position;
            Rb.rotation = Original_Rotation;
            Rb.velocity = Vector3.zero;
            Rb.angularVelocity = Vector3.zero;
            elapsed_time = 0;
            return;
        }
    }
}
