﻿using UnityEngine;

public class SquishyToy : MonoBehaviour
{
    //public Interactable interactable;
    public new SkinnedMeshRenderer renderer;

    public bool affectMaterial = true;

    public float GripValue = 0.0f;
    public float PinchValue = 0.0f;

    private new Rigidbody rigidbody;

    private void Start()
    {
        if (rigidbody == null)
            rigidbody = GetComponent<Rigidbody>();

        if (renderer == null)
            renderer = GetComponent<SkinnedMeshRenderer>();
    }


    private void Update()
    {

        renderer.SetBlendShapeWeight(0, Mathf.Lerp(renderer.GetBlendShapeWeight(0), GripValue * 100, Time.deltaTime * 10));

        if (renderer.sharedMesh.blendShapeCount > 1) // make sure there's a pinch blend shape
            renderer.SetBlendShapeWeight(1, Mathf.Lerp(renderer.GetBlendShapeWeight(1), PinchValue * 100, Time.deltaTime * 10));

        if (affectMaterial)
        {
            renderer.material.SetFloat("_Deform", Mathf.Pow(GripValue * 1f, 0.5f));
            if (renderer.material.HasProperty("_PinchDeform"))
            {
                renderer.material.SetFloat("_PinchDeform", Mathf.Pow(PinchValue * 1f, 0.5f));
            }
        }
    }
}